# ee-monitoring

## Packages

- **ee-monitoring-plugins :** Dependency package for *eenrpe* and *eeicinga2-agent*, that installs probes common to those packages
- **ee-monitoring-plugins-backuppc :** Checks for a BackupPC instance
- **eenrpe :** Easter-eggs collected or self written *NRPE* compatible checks
- **eeicinga2-agent :** Package that installs *icinga2* agent
- **eehosting-nrpe :** Package that allows Ee Icinga2 servers to monitor the host

## Dev environment

We are using some python tools to maintain our python plugins code clean: `pylint`, `flake8`, `pyupgrade`, `black`, `isort` and `bandit`.

We also use _pre-commit_ to make sure all this tools are run before commiting, so make sure is available and installed in your repository clone:

```bash
apt install pre-commmit pylint flake8
cd ~/path/clone
pre-commit install
```

Note: `pylint` and `flake8` must be locally present on system and all other tools are automatically fetched and installed in a cached virtual environment by _pre-commit_.

## Publish a new release

__Before publishing a new release, make sure (in particular, if you added a new plugin):__

- your new plugin does not have the same name as a [standard plugins](https://packages.debian.org/search?keywords=monitoring-plugins) (may be provided in particular by [monitoring-plugins-basic](https://packages.debian.org/bookworm/amd64/monitoring-plugins-basic/filelist), [monitoring-plugins-standard](https://packages.debian.org/bookworm/amd64/monitoring-plugins-standard/filelist) or [monitoring-plugins-contrib](https://packages.debian.org/bookworm/amd64/monitoring-plugins-contrib/filelist) packages)
- you have update package dependency if necessary (in `debian/control` file)
- you have provided the `eenrpe` check configuration
- you have provided the `sudoers` configuration for the check. Make sure call arguments are the same in case of NRPE check or Icinga agent check. If it's not the case, split `sudoers` file in `eenrpe` and `eeicinga2-agent` directories. Note: for Icinga agent check, you can add the `order` arguments configuration key to fix the order of arguments.

If all it's OK :

- Make all changes needs in the `master` branch with explicit commits messages that will be used to compose the Debian changelog entries
- Keep list of your commits ID
- Push changes to remote repository: `git push`
- For each Debian supported release:
  - switch to dedicated branch: `git checkout bullseye`
  - update the branch: `git pull origin bullseye`
  - retreive changes from the `master` branch: `git cherry-pick [commit ID]`
  - add the version tag: `git tag 2.0.7-ee110`
  - push changes to remote repository: `git push origin bullseye && git push --tags`

__Note:__ to avoid to leave pending upgrades on these packages and immediately know if your new release introduce problems, remember to force upgrade after publishing a new release:

```bash
ansible-playbook playbooks/upgrade-packages.yml \
  --tags update \
  -e '{
    "packages": [
      "eehosting-nrpe",
      "eeicinga2-agent",
      "ee-monitoring-plugins",
      "ee-monitoring-plugins-backuppc",
      "eenrpe"
    ]
  }'
```

## Locally build (using Docker)

You also could manually build a specific release using the following command:

```bash
docker run --rm -it -v "$(pwd):/src" -w /src -e DEBFULLNAME -e DEBEMAIL -e GPG_KEY debian:11 ./build.sh --install-build-deps
```

Release builded files will be store in the `dist` directory.

### Packages signing

By default, builded packages are not signed but you could provided information to allow their signature :

- be sure to define `DEBFULLNAME` and `DEBEMAIL` environment variables
- run the `docker run` command in a context where the `GPG_KEY` environment variable is set as follow :

```bash
GPG_KEY=$( gpg --armor --export-secret-key $DEBEMAIL|base64|tr -d '\n' )
```

**Important :** This solution only work with GPG key **without password** defined. If you have to use a GPG key with a password, you have to remove it before by running the following command :

```
gpg --edit-key $DEBEMAIL
> passwd
> quit
```

Be sure to restore your password after building the Debian packages.

**Note :** the `build.sh` script accept a `--gpg-key` parameter, but it will only works if the GPG key is available in the running context, so probably not in a docker container or not if script is run with `sudo`.
