#============================================================= -*-perl-*-
#
# BackupPC::CGI::RestoreInfo package
#
# DESCRIPTION
#
#   This module implements the RestoreInfo action for the CGI interface.
#
# AUTHOR
#   Craig Barratt  <cbarratt@users.sourceforge.net>
#
# COPYRIGHT
#   Copyright (C) 2003-2020  Craig Barratt
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#========================================================================
#
# Version 4.4.0, released 20 Jun 2020.
#
# See http://backuppc.sourceforge.net.
#
#========================================================================

package BackupPC::CGI::HostStatusJSON;

use strict;
use BackupPC::CGI::Lib qw(:all);
use Encode qw/decode_utf8/;
use JSON::XS;
use File::Find;

sub ErrorJSON {
    my ( $msg ) = @_;
    my %err;
    $err{-1} = $msg;
    print "Content-type: application/json; charset=utf-8\n\n";
    print encode_json(\%err);
    exit();
}


sub action
{
    my $Privileged = CheckPermission($In{host});
    my $host       = $1 if ( $In{host} =~ /(.*)/ );
    my $i;

    if ( !$Privileged ) {
        ErrorJSON("You can't view restores info of this host");
    }

    %StatusHost = ();
    GetStatusInfo("host(${EscURI($host)})");

    if (exists $StatusHost{Job}) {
        # The two following keys can't be JSON encode, drop them
        delete $StatusHost{Job}{fn};
        delete $StatusHost{Job}{fh};

        # If a restore job is running, retreive request info
        #
        # Note: Restore request info are store in a restoreReq.X.Y file
        # in PC directory. This filename is the latest argument passed to
        # BackupPC_restore command available in $StatusHost{Job}{cmd}.
        if (
            $StatusHost{Job}{type} eq 'restore'
            and $StatusHost{Job}{cmd} =~ /(restoreReq\.\d+\.\d)$/
        ) {
            %RestoreReq = ();
            do "$TopDir/pc/$host/$1" if (-e "$TopDir/pc/$host/$1");
            $StatusHost{Job}{req} = \%RestoreReq;
        }
    }

    print "Content-type: application/json; charset=utf-8\n\n";
    print encode_json(\%StatusHost);
}

1;
