# ee-authorized-keys

Deploys Easter-eggs admin's public SSH keys.

## Publish a new release

- Make all changes needed in the ''master'' branch, with explicit commit messages that will be used to compose the Debian changelog entries.
  - add the version tag: 2.5
  - push changes to remote repository: ''git push && git push --tags''

The ''master'' branch only handles Debian releases from ''bullseye'' and later.
Older releases (''buster'', ''jessie''...) are still in this repo for archive.

## Locally build (using Docker)

You also could manually build a specific release using the following command:

```bash
docker run --rm -it -v "$(pwd):/src" -w /src -e DEBFULLNAME -e DEBEMAIL -e GPG_KEY debian:12 ./build.sh --install-build-deps
```

Release builded files will be stored in the `dist` directory.

### Packages signing

By default, builded packages are not signed but you could provide information to allow their signature :

- be sure to define `DEBFULLNAME` and `DEBEMAIL` environment variables
- run the `docker run` command in a context where the `GPG_KEY` environment variable is set as follow :

```bash
GPG_KEY=$( gpg --armor --export-secret-key $DEBEMAIL|base64|tr -d '\n' )
```

**Important :** This solution only works with GPG key **without password** defined. If you have to use a GPG key with a password, you have to remove it before by running the following command :

```
gpg --edit-key $DEBEMAIL
> passwd
> quit
```

Be sure to restore your password after building the Debian packages.

**Note :** the `build.sh` script accepts a `--gpg-key` parameter, but it will only work if the GPG key is available in the running context, so probably not in a docker container or not if script is run with `sudo`.
