# vim: shiftwidth=4 tabstop=4 expandtab
import os
import logging
import django

A2_IDP_SAML2_ENABLE = True
A2_PROFILE_CAN_CHANGE_EMAIL = False
A2_PROFILE_CAN_EDIT_PROFILE = False
A2_CAN_RESET_PASSWORD = False
REGISTRATION_OPEN = False
A2_REGISTRATION_CAN_CHANGE_PASSWORD = False
A2_REGISTRATION_CAN_DELETE_ACCOUNT = False

A2_IDP_SAML2_EDU_PERSON_TARGETED_ID_ATTRIBUTE = 'username'
with open('/etc/authentic2/edu_person_targeted_id.salt') as fd:
    A2_IDP_SAML2_EDU_PERSON_TARGETED_ID_SALT = fd.read()

with open('/etc/authentic2/cert.pem') as fd:
    SAML_SIGNATURE_PUBLIC_KEY = fd.read()

with open('/etc/authentic2/key.pem') as fd:
    SAML_SIGNATURE_PRIVATE_KEY = fd.read()

SUPANN_LDAP_EXTRA_ATTRIBUTES = list(filter(None, os.environ.get('SUPANN_LDAP_EXTRA_ATTRIBUTES', '').split()))

LDAP_AUTH_SETTINGS = [
    {
        'url': os.environ['SUPANN_LDAP_URL'],
        'user_filter': '(&(|(mail=%s)(supannAutreMail=%s)(supannAliasLogin=%s)(uid=%s))(objectClass=supannPerson))',
        'basedn': os.environ['SUPANN_LDAP_BASE_DN'],
        'binddn': os.environ.get('SUPANN_LDAP_BINDDN'),
        'bindpw': os.environ.get('SUPANN_LDAP_BINDPW'),
        'groupsu': 'cn=admin,ou=groups,%s' % os.environ['SUPANN_LDAP_BASE_DN'],
        'groupstaff': 'cn=admin,ou=groups,%s' % os.environ['SUPANN_LDAP_BASE_DN'],
        'username_template': '{uid[0]}',
        'external_id_tuples': (('uid',), ('dn:noquote',), ),
        'lookups': ('external_id',),
        'update_username': False,
        'use_tls': os.environ.get('USE_TLS') != '0',
        'attributes': [
            'audio',
            'businessCategory',
            'carLicense',
            'cn',
            'departmentNumber',
            'description',
            'destinationIndicator',
            'displayName',
            'eduPersonAssurance',
            'eduPersonEntitlement',
            'eduPersonNickname',
            'eduPersonOrgDN',
            'eduPersonOrgUnitDN',
            'eduPersonAffiliation',
            'eduPersonPrimaryAffiliation',
            'eduPersonPrimaryOrgUnitDN',
            'eduPersonPrincipalName',
            'eduPersonScopedAffiliation',
            'eduPersonUniqueId',
            'employeeType',
            'fax',
            'ferredLanguage',
            'givenName',
            'homePhone',
            'homePostalAddress',
            'ini',
            'internationaliSDNNumber',
            'jpegPhoto',
            'l',
            'labeledURI',
            'mail',
            'mailForwardingAddress',
            'manager',
            'mobile',
            'o',
            'ou',
            'pager',
            'photo',
            'physicalDeliveryOfficeName',
            'ployeeNumber',
            'postalAddress',
            'postalCode',
            'postOfficeBox',
            'pre',
            'preferredDeliveryMethod',
            'preferredLanguage',
            'registeredAddress',
            'roomNumber',
            'secretary',
            'seeAlso',
            'sn',
            'st',
            'street',
            'supannActivite',
            'supannAliasLogin',
            'supannAutreMail',
            'supannAutreTelephone',
            'supannCivilite',
            'supannCodeINE',
            'supannEmpCorps',
            'supannEmpId',
            'supannEntiteAffectation',
            'supannEntiteAffectationPrincipale',
            'supannEtablissement',
            'supannEtuAnneeInscription',
            'supannEtuCursusAnnee',
            'supannEtuDiplome',
            'supannEtuElementPedagogique',
            'supannEtuEtape',
            'supannEtuId',
            'supannEtuInscription',
            'supannEtuRegimeInscription',
            'supannEtuSecteurDisciplinaire',
            'supannEtuTypeDiplome',
            'supannListeRouge',
            'supannMailPerso',
            'supannParrainDN',
            'supannRefId',
            'supannRoleEntite',
            'supannRoleGenerique',
            'supannTypeEntiteAffectation',
            'telephoneNumber',
            'teletexTerminalIdentifier',
            'telexNumber',
            'tials',
            'title',
            'uid',
            'userCertificate',
            'userPassword',
            'userPKCS12',
            'userSMIMECertificate',
            'x121Address',
            'x500uniqueIdentifier',
        ] + SUPANN_LDAP_EXTRA_ATTRIBUTES,
        'attribute_mappings': (('mail', 'email'),),
        'mandatory_attributes_values': {
            # edugain support
            'schacHomeOrganization': [os.environ['EDUGAIN_SCHAC_HOME_ORGANIZATION']],
            'schacHomeOrganizationtype': [os.environ['EDUGAIN_SCHAC_HOME_ORGANIZATION_TYPE']],
        },
    }
]
AUTHENTICATION_BACKENDS = (
    'authentic2.backends.ldap_backend.LDAPBackend',
    'authentic2.custom_user.backends.DjangoRBACBackend',
)

def generate_eduPersonScopedAffiliation(ctx):
    attrs = ctx['user'].get_attributes(None, ctx)
    if 'edupersonaffiliation' not in attrs:
        logging.warning('generate_eduPersonScopedAffiliation: no edupersonaffiliation attribute found')
        return []

    domain = os.environ.get('EDU_SCOPED_AFFILIATION_DOMAIN')
    if not domain:
        logging.warning('generate_eduPersonScopedAffiliation: EDU_SCOPED_AFFILIATION_DOMAIN not found in env')
        return []

    logging.warning('generate_eduPersonScopedAffiliation: edupersonaffiliation = %s / domain = %s', attrs['edupersonaffiliation'], domain)
    return ["%s@%s" % (aff, domain) for aff in attrs['edupersonaffiliation']]

ATTRIBUTE_SOURCES = [
    ('function', {
        'name': 'entity_id',
        'dependencies': ['service'],
        'function': lambda ctx: getattr(ctx.get('service'), 'entity_id', ''),
    }),
    ('function', {
        'name': 'edupersonscopedaffiliation',
        'dependencies': ['user'],
        'function': generate_eduPersonScopedAffiliation
    }),
]

# bypass authentic2 warning: "DEFAULT_FROM_EMAIL must be customized"
DEFAULT_FROM_EMAIL = 'root@localhost'

# Configure session & CSRF cookies with flags samesite=none & secure=true
# to avoid cross-site common problems
SESSION_COOKIE_SECURE= True
CSRF_COOKIE_SECURE= True
if (django.VERSION[0] + django.VERSION[1]/10) >= 3.1:
    SESSION_COOKIE_SAMESITE = 'None'
    CSRF_COOKIE_SAMESITE = 'None'

# Session expiration
SESSION_COOKIE_AGE = int(os.environ.get('SESSION_COOKIE_AGE', 10 * 3600))
SESSION_EXPIRE_AT_BROWSER_CLOSE = True

if os.environ.get('DEBUG') == '1':
    DEBUG = True
    for logger in LOGGING['loggers'].values():
        logger['level'] = 'DEBUG'
