# Packaging notes

We mostly follow git-buildpackage's documentation, especially section [When upstream uses Git][doc-gbp].


## Quick-start

```
git clone <this_repo> debianize-rochetchat
cd debianize-rocketchat
git remote add upstream https://github.com/RocketChat/Rocket.Chat.git
git fetch upstream
sudo apt build-dep .
gbp buildpackage
```

## Build a specific release

```
export VERSION=3.18.0
git fetch --all
gbp import-ref --merge-mode=replace -u ${VERSION?}
dch --newversion "${VERSION?}-1" "New upstream release"
git commit -m "Start packaging ${VERSION?}" debian/changelog
# ... refresh patches, build, fix problems, build, ....
quilt push -a --refresh ; quilt pop -a ; rm .pc/ -rf
dch --release --distribution bookworm-ee --force-distribution ""
git commit -m "Release ${VERSION?}-1" debian/changelog
gbp buildpackage
# dupload...
```

[doc-gbp]: https://honk.sigxcpu.org/projects/git-buildpackage/manual-html/gbp.import.upstream-git.html

