import type { Locator, Page } from '@playwright/test';

import { OmnichannelSidenav } from './fragments';

export class OmnichannelTranscript {
	private readonly page: Page;

	readonly sidenav: OmnichannelSidenav;

	constructor(page: Page) {
		this.page = page;
		this.sidenav = new OmnichannelSidenav(page);
	}

	get checkboxPDF(): Locator {
		return this.page.locator('//input[@name="transcriptPDF"]//following::i[1]');
	}

	get contactCenter(): Locator {
		return this.page.locator('//button[@data-tooltip="Contact Center"]');
	}

	get contactCenterChats(): Locator {
		return this.page.locator('//button[contains(.,"Chats")]');
	}

	get contactCenterSearch(): Locator {
		return this.page.locator('[placeholder="Search"]');
	}

	get firstRow(): Locator {
		return this.page.locator('//tr[1]//td[1]');
	}

	get btnOpenChat(): Locator {
		return this.page.getByRole('dialog').getByRole('button', { name: 'Open chat', exact: true });
	}

	get DownloadedPDF(): Locator {
		return this.page.locator('[data-qa-type="attachment-title-link"]').last();
	}
}
