import type { ITeam, TEAM_TYPE } from '@rocket.chat/core-typings';

import { api, request } from './api-data';

export const createTeam = async (
	credentials: Record<string, any>,
	teamName: string,
	type: TEAM_TYPE,
	members?: string[],
): Promise<ITeam> => {
	const response = await request
		.post(api('teams.create'))
		.set(credentials)
		.send({
			name: teamName,
			type,
			...(members && { members }),
		});

	return response.body.team;
};

export const deleteTeam = async (credentials: Record<string, any>, teamName: string): Promise<void> => {
	await request.post(api('teams.delete')).set(credentials).send({
		teamName,
	});
};
