<p align="center"> 
  <img  src="https://github.com/RocketChat/Rocket.Chat.Artwork/raw/master/Logos/2020/png/logo-horizontal-red.png" data-canonical-src="https://github.com/RocketChat/Rocket.Chat.Artwork/raw/master/Logos/2020/png/logo-horizontal-red.png" width="400" />
</p>

<h1 align="center">
  The ultimate Free Open Source Solution for team communications
</h1>

<p align="center">
  <img src="https://img.shields.io/github/v/release/RocketChat/Rocket.Chat?label=version">
  <img src="https://img.shields.io/github/actions/workflow/status/RocketChat/Rocket.Chat/build_and_test.yml">
  <img src="https://img.shields.io/badge/license-MIT-green">
  <img alt="Codecov branch" src="https://img.shields.io/codecov/c/github/RocketChat/Rocket.Chat/develop">
</p>



[Rocket.Chat](https://rocket.chat) is an open-source fully customizable communications platform developed in JavaScript for organizations with high standards of data protection.

We are the ultimate **Free Open Source Solution** for team communications, enabling real-time conversations between colleagues, with other companies or with your customers, regardless of how they connect with you. The result is an increase in productivity and customer satisfaction rates.

Every day, tens of millions of users in over 150 countries and in organizations such as Deutsche Bahn, The US Navy, and Credit Suisse trust Rocket.Chat to keep their communications completely private and secure.

# 🚀 Product Offerings - Self-hosted and Cloud

Rocket.Chat has four key product offerings: 

💬 **Team collaboration** - A single point for secure internal and cross-company collaboration.

🎯 **Omnichannel customer service** - Engage in seamless interactions with customers regardless of how they connect with you.

🦾 **Chat engine** - Create customized messaging experiences within your mobile or web app.

🤖 **Marketplace** - Choose a wide range of apps and native integrations that help your business communicate more effectively.

<img src="https://global-uploads.webflow.com/611a19b9853b7414a0f6b3f6/6319c72bbd8af5c8c22efab6_heroImage.webp" data-canonical-src="https://global-uploads.webflow.com/611a19b9853b7414a0f6b3f6/6319c72bbd8af5c8c22efab6_heroImage.webp"  />

# ☁️ Cloud-hosted Rocket.Chat

Rocket.Chat has flexible hosting options that adapt to your infrastructure needs.
For more information please [follow this link](https://www.rocket.chat/hosting)

# 📖 Docs for Developers, Admins and Users

Visit our official [User Documentation](https://docs.rocket.chat/) and [Developer Docs](https://developer.rocket.chat/docs) before sending questions.

# 🛠️ Local Development

You can set up a Rocket.Chat server development environment by following the guide below for your operating system:


- [Linux](https://developer.rocket.chat/docs/linux): See how to set up a Rocket.Chat server development environment on any Linux distribution.

- [Mac OSX](https://developer.rocket.chat/docs/mac-osx): Learn how to set up a Rocket.Chat server development environment on Mac.

- [Windows 10](https://developer.rocket.chat/docs/windows-10): Set up a Rocket.Chat server development environment on Windows.

- [Gitpod](https://developer.rocket.chat/docs/gitpod): Use the online development environment pre-configuration to develop Rocket.Chat server.

> Visit the [Rocket.Chat Environment Setup guide](https://developer.rocket.chat/docs/server-environment-setup) to learn more.


# 💻 Deploy Rocket.Chat

Refer to the [System requirements documentation](https://docs.rocket.chat/docs/system-requirements) for required hardware and software specifications. For detailed instructions on deploying your Rocket.Chat workspace, visit [Deploy Rocket.Chat](https://rocket.chat/install).

# 📱 Mobile apps

In addition to the web app, you can also download Rocket.Chat clients for:


[![Rocket.Chat on Apple App Store](https://user-images.githubusercontent.com/551004/29770691-a2082ff4-8bc6-11e7-89a6-964cd405ea8e.png)](https://itunes.apple.com/us/app/rocket-chat/id1148741252?mt=8) [![Rocket.Chat on Google Play](https://user-images.githubusercontent.com/551004/29770692-a20975c6-8bc6-11e7-8ab0-1cde275496e0.png)](https://play.google.com/store/apps/details?id=chat.rocket.android)

You can also contribute to the mobile open source code in [Rocket.Chat.ReactNative](https://github.com/RocketChat/Rocket.Chat.ReactNative) and check it out its [documentation](https://developer.rocket.chat/docs/mobile-app).

# 🧩 Apps Engine for Rocket.Chat

You can develop your own app that can be integrated with Rocket.Chat. We provide an [Open Source Apps-Engine framework](https://developer.rocket.chat/apps-engine/getting-started) which expands the integration possibilities within the Rocket.Chat ecosystem.

# 📚 Learn More

- [User documentation](https://docs.rocket.chat)
- [Developer documentation](https://developer.rocket.chat)
- [API documentation](https://developer.rocket.chat/reference/api)
- [Apps-Engine development](https://developer.rocket.chat/apps-engine/rocket.chat-apps-and-apps-engine)
- [See who's using Rocket.Chat](https://www.rocket.chat/customers)

# 🆕 Feature Request

[Rocket.Chat/feature-requests](https://github.com/RocketChat/feature-requests) is used to track Rocket.Chat feature requests and discussions. Click [here](https://github.com/RocketChat/feature-requests/issues/new?template=feature_request.md) to open a new feature request. [Feature Request Forums](https://forums.rocket.chat/c/feature-requests/8) stores the historical archives of old feature requests (up to 2018).

# 🤝 Community

Join thousands of members worldwide in our [community server](https://open.rocket.chat).
Join [#support](https://open.rocket.chat/channel/support) and [#general](https://open.rocket.chat/channel/general) for help from the community.


# 👥 Contributions

Rocket.Chat is an open source project and we are very happy to accept community contributions. Refer to the [Modes of contribution guide](https://developer.rocket.chat/contribute-to-rocket.chat/ways-to-contribute) for more details.


# 💼 Become a Rocketeer

We're hiring developers, support people, and product managers all the time. Check out our [jobs page](https://rocket.chat/jobs).

# 🗞️ Get the Latest News

- [Blog](https://rocket.chat/blog)
- [Twitter](https://twitter.com/RocketChat)
- [Facebook](https://www.facebook.com/RocketChatApp)
- [LinkedIn](https://www.linkedin.com/company/rocket-chat)
- [Youtube](https://www.youtube.com/channel/UCin9nv7mUjoqrRiwrzS5UVQ)

# 🗒️ Credits

- Emoji provided graciously by [JoyPixels](https://www.joypixels.com).
