By default, this package will start a single instance of Rocket.Chat via the
systemd unit rocketchat-server@main.service.

If you have an increasing number of users then performance may deteriorate.
This is because nodejs can't take advantage of multiple cores. Then the solution
is to run multiple Rocket.Chat processes and configure a reverse proxy with
load-balancing capabilities (apache or nginx for example).
Read [upstream documentation][rocketchat-multiple-instances] for more details.

## How to create a new instance?

In folder /etc/rocketchat-server/instances/, create a new file 3001.conf by
copying main.conf and change the PORT= parameter. You would end up with
something like this:

    MONGO_URL=mongodb://localhost:27017/rocketchat?replicaSet=rs01
    MONGO_OPLOG_URL=mongodb://localhost:27017/local?replicaSet=rs01
    ROOT_URL=https://chat.localhost.localdomain/
    PORT=3001

Then run `systemctl daemon-reload` and `systemctl start rocketchat-server@3002.service`.
Notice that when you start/stop/reload the service rocketchat-server.service it will
automatically start/stop/reload all your instances at the same time.

[rocketchat-multiple-instances]: https://docs.rocket.chat/deploy/prepare-for-your-deployment/scaling-rocket.chat/running-multiple-instances
