# EEGO

Because Xapian doesn't support multiple writers on its databases, the API side should only be executed on a single worker.

## Configuration

Create file `/etc/eego.toml`:
```toml
[xapian]
db_path = "/var/www/eego/db/default/"

[injectors]
eego-api-token = "32 hex chars"
eego-api-base-uri = "http://localhost:8080/api/v1"

[injectors.dokuwiki_media]
base-path = "/var/www/wiki/dokuwiki/data/media"
base-uri = "https://www.easter-eggs.fr/_media"

[injectors.dokuwiki_pages]
base-path = "/var/www/wiki/dokuwiki/data/pages"
base-uri = "https://www.easter-eggs.fr"

[injectors.rose]
base-path = "/home/ee"
base-uri = "file:///home/ee"

[injectors.rt]
token = "RT token"
```

## Quickstart

### Start eego API using uwsgi

```shell
cd src/ && flask --app eego.wsgi run
```

## Usage

```shell
cd src/
python -m eego.cli --help
```

## Tooling

```shell
invoke
```

## Dependencies

On Debian 12.

```shell
apt install \
	python3-flask \
	python3-pdfminer \
	python3-pypandoc \
	python3-requests \
	python3-rt \
	python3-xapian \

```

### Development dependencies

```shell
apt install \
	git \
	flake8 \
	isort \
	black \
	yamllint \
	mypy python3-typeshed \
	pylint \
	python3-invoke \
	python3-pytest python3-pytest-cov \

```

## License

EEGO is published under [the AGPLv3+](LICENSE.md).
