import pytest
from flask import Flask
from xapian import (
    DB_CREATE,
    DB_OPEN,
    Database,
    Enquire,
    MSet,
    QueryParser,
    Stem,
    WritableDatabase,
)

from eego.api import EegoWritableDatabase, create_app


@pytest.fixture
def app(
    tmp_path_factory: pytest.TempPathFactory,
) -> Flask:
    app = create_app(EegoWritableDatabase())
    app.config.update(
        {
            "DB_PATH": tmp_path_factory.mktemp("db"),
            "TESTING": True,
        }
    )
    WritableDatabase(str(app.config["DB_PATH"]), DB_CREATE)
    return app


def database_results(app: Flask) -> MSet:
    database = Database(str(app.config["DB_PATH"]), DB_OPEN)
    queryparser = QueryParser()
    queryparser.set_stemmer(Stem("fr"))
    query = queryparser.parse_query("probably")
    enquire = Enquire(database)
    enquire.set_query(query)
    return enquire.get_mset(0, 1)


def database_results_unfound(
    app: Flask,
) -> None:
    assert database_results(app).size() == 0


def database_results_found(
    app: Flask,
) -> None:
    assert database_results(app).size() == 1
