from dataclasses import dataclass
from pathlib import PosixPath
from tomllib import load
from typing import Any  # pylint: disable=wrong-import-order


@dataclass
class Document:
    url: str
    source: str
    content: str
    title: str
    modtime: float
    size: int
    modtime_cache: float | None = None


def get_config(test: bool = False) -> dict[str, Any]:
    with PosixPath("tests/resources/config.toml" if test else "/etc/eego.toml").open(
        "rb"
    ) as file:
        config = load(file)
        config["test"] = test
        return config
